% Section 7.8 Tutorial Example2
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System
A = [-0.025 01.04 -09.94; 57.47 0 0; 1.62 0 0];
B = [0.122 -0.276; -5.361 3.325; 19.55 -52.94];
C = eye(3); 
Fa = [1;0];
Da = [0;1];
Ds = [0.1;0.2;1];
F = B*Fa;
D1 = [zeros(3,1) B*Da]; 
D2 = [Ds zeros(3,1)];

K = [-6.841 -0.2919 0.1227;
    7.9536  0.1866 -0.3261];

% Global variables 
% Attenuation observer
global Intr_ts Intr_count Intr_tmp
global Intr_hatf1 Intr_hatx1 Intr_hatx2 Intr_hatx3 Intr_f1 

Intr_ts = []; Intr_count = 0; Intr_tmp = 0; Intr_hatf1 = []; 
Intr_hatx1 = []; Intr_hatx2 = []; Intr_hatx3 = []; Intr_f1 = []; 

% Partial observer
global Intp_ts Intp_count Intp_tmp
global Intp_hatf1 Intp_hatx1 Intp_hatx2 Intp_hatx3 Intp_f1 

Intp_ts = []; Intp_count = 0; Intp_tmp = 0; Intp_hatf1 = []; 
Intp_hatx1 = []; Intp_hatx2 = []; Intp_hatx3 = []; Intp_f1 = []; 

% Proposed observer
global Intd_ts Intd_count Intd_tmp
global Intd_hatf1 Intd_hatx1 Intd_hatx2 Intd_hatx3 Intd_hatd1 Intd_hatd2 Intd_f1 
global Intd_ey1 Intd_ey2 Intd_ey3

Intd_ts = []; Intd_count = 0; Intd_tmp = 0; Intd_hatf1 = []; Intd_hatx1 = []; 
Intd_hatx2 = []; Intd_hatx3 = []; Intd_hatd1 = []; Intd_hatd2 = [];  Intd_f1 = []; 
Intd_ey1 = []; Intd_ey2 = []; Intd_ey3 = [];


% Initial conditon
x0 = [1 -2 -1]';
z0 = zeros(4,1);
rho0 = 0;
veq0 = zeros(3,1);


% Simulation time
t0 = 0;
tf = 5;
tspan = [t0,tf];


% Method1: Attenuation approach
% solve observer gains
[N_r,J_r,L_r,H_r] = Attenuation_observer(A,B,F,D1,C,D2)

% system simulation
xx0_r = [x0' z0']; % initial condition
[Intr_tt,Intr_yy] = ode45(@(t,xx) Attenuation_Closed_sys(t,xx, A, B, C, D1, D2, F, K, N_r, J_r, L_r, H_r), tspan, xx0_r);

% Method2: Partial decoupling approach
% solve observer gains
[N_p,J_p,L_p,H_p] = Partial_observer(A,B,F,D1,C,D2)

% system simulation
z0_d = zeros(5,1); xx0_p = [x0' z0_d']; % initial conditions
[Intp_tt,Intp_yy] = ode45(@(t,xx) Partial_Closed_sys(t,xx, A, B, C, D1, D2, F, K, N_p, J_p, L_p, H_p), tspan, xx0_p);

% Method3: Proposed
% solve observer gains
[N,J,L,W,H,Ud,Vd,P,Q,C_bar] = Proposed_observer(A,B,F,D1,C,D2)
sigma0 = 2.5e3; delta = 1.0e-3; tau = 1.0e-3; % other observer gains

% system simulation
xx0_d = [x0' z0' rho0' veq0']; % initial condition
[Intd_tt,Intd_yy] = ode45(@(t,xx) Proposed_Closed_sys(t,xx, A, B, C, D1, D2, F, K, N, J, L, W, H, Ud, Vd, P, Q,C_bar, sigma0, delta,tau), tspan, xx0_d);


% Draw figures
run('Draw_figure.m');